import UIKit

class Sedan: Vehicle {
    var curGear : Int = 0

    // init using a dict
    
    convenience init? (inpDict: Dictionary <String, Any>)    {
        guard let name = inpDict ["nameKey"] as? String,
        let gears = inpDict ["gearsKey"] as? Int,
        let colorStr = inpDict ["colorKey"] as? String,
        let statusStr = inpDict ["statusKey"] as? String
        else        {
            return nil
        }
        
        var status = VehicleState.available
        for anyCase in VehicleState.allCases        {
            if ( statusStr == "\(anyCase)")            {
                status = anyCase
            }
        }

        self.init(inpName: name,
                  inpColor: colorStr.color!,
                  inpMaxear: gears,
                  inpStatus: status)
    }
}
